/**
 * \file: libsugc.c
 *
 * \brief : Library to switch user, group, supplementary groups and capabilities
 *          according to a named configuration
 *
 * \author: Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2017 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#include <libsugc.h>
#include "libsugc_config.h"
#include "libsugc_set.h"
#include "libsugc_log.h"

libsugc_error_t libsugc_apply_cfg(const char *config_name)
{
    libsugc_error_t err;
    libsugc_error_t tmperr;

    libsugc_config_t config;

    err = libsugc_init_config(&config);

    if (err == LIBSUGC_OK)
        err = libsugc_fill_config(config_name, &config);

    if (err == LIBSUGC_OK)
        err = libsugc_apply_config(&config);

    if (err != LIBSUGC_OK)
        libsugc_set_fallback_config();

    tmperr = libsugc_free_config(&config);
    if (err == LIBSUGC_OK)
        err = tmperr;

    return err;
}
